/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d;

import math.geom2d.Angle2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.NonInvertibleTransform2DException;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.transform.Bijection2D;

public class AffineTransform2D
implements Bijection2D,
GeometricObject2D,
Cloneable {
    protected double m00;
    protected double m01;
    protected double m02;
    protected double m10;
    protected double m11;
    protected double m12;

    public static AffineTransform2D createIdentity() {
        return new AffineTransform2D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    public static AffineTransform2D create(AffineTransform2D trans) {
        double[][] mat = trans.getAffineMatrix();
        return new AffineTransform2D(mat[0][0], mat[0][1], mat[0][2], mat[1][0], mat[1][1], mat[1][2]);
    }

    public static AffineTransform2D create(double[] coefs) {
        if (coefs.length == 4) {
            return new AffineTransform2D(coefs[0], coefs[1], 0.0, coefs[2], coefs[3], 0.0);
        }
        if (coefs.length == 6) {
            return new AffineTransform2D(coefs[0], coefs[1], coefs[2], coefs[3], coefs[4], coefs[5]);
        }
        throw new IllegalArgumentException();
    }

    public static AffineTransform2D create(double xx, double yx, double tx, double xy, double yy, double ty) {
        return new AffineTransform2D(xx, yx, tx, xy, yy, ty);
    }

    public static AffineTransform2D createGlideReflection(LinearShape2D line, double distance) {
        Vector2D vector = line.getVector().getNormalizedVector();
        Point2D origin = line.getOrigin();
        double dx = vector.getX();
        double dy = vector.getY();
        double x0 = origin.getX();
        double y0 = origin.getY();
        double tx = dx * distance;
        double ty = dy * distance;
        double delta = dx * dx + dy * dy;
        double dx2 = dx * dx;
        double dy2 = dy * dy;
        double dxy = dx * dy;
        double dxy0 = dx * y0;
        double dyx0 = dy * x0;
        return new AffineTransform2D((dx2 - dy2) / delta, 2.0 * dxy / delta, 2.0 * dy * (dyx0 - dxy0) / delta + tx, 2.0 * dxy / delta, (dy2 - dx2) / delta, 2.0 * dx * (dxy0 - dyx0) / delta + ty);
    }

    public static AffineTransform2D createHomothecy(Point2D center, double k) {
        return AffineTransform2D.createScaling(center, k, k);
    }

    public static AffineTransform2D createLineReflection(LinearShape2D line) {
        Vector2D vector = line.getVector();
        Point2D origin = line.getOrigin();
        double dx = vector.getX();
        double dy = vector.getY();
        double x0 = origin.getX();
        double y0 = origin.getY();
        double delta = dx * dx + dy * dy;
        return new AffineTransform2D((dx * dx - dy * dy) / delta, 2.0 * dx * dy / delta, 2.0 * dy * (dy * x0 - dx * y0) / delta, 2.0 * dx * dy / delta, (dy * dy - dx * dx) / delta, 2.0 * dx * (dx * y0 - dy * x0) / delta);
    }

    public static AffineTransform2D createPointReflection(Point2D center) {
        return AffineTransform2D.createScaling(center, -1.0, -1.0);
    }

    public static AffineTransform2D createQuadrantRotation(int numQuadrant) {
        int n = (numQuadrant % 4 + 4) % 4;
        switch (n) {
            case 0: {
                return new AffineTransform2D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            }
            case 1: {
                return new AffineTransform2D(0.0, -1.0, 0.0, 1.0, 0.0, 0.0);
            }
            case 2: {
                return new AffineTransform2D(-1.0, 0.0, 0.0, 0.0, -1.0, 0.0);
            }
            case 3: {
                return new AffineTransform2D(0.0, 1.0, 0.0, -1.0, 0.0, 0.0);
            }
        }
        return new AffineTransform2D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    public static AffineTransform2D createRotation(double angle) {
        return AffineTransform2D.createRotation(0.0, 0.0, angle);
    }

    public static AffineTransform2D createRotation(Point2D center, double angle) {
        return AffineTransform2D.createRotation(center.getX(), center.getY(), angle);
    }

    public static AffineTransform2D createRotation(double cx, double cy, double angle) {
        angle = Angle2D.formatAngle(angle);
        double cot = 1.0;
        double sit = 0.0;
        int k = (int)Math.round(angle * 2.0 / Math.PI);
        if (Math.abs((double)k * Math.PI / 2.0 - angle) < 1.0E-12) {
            assert (k >= 0) : "k should be positive";
            assert (k < 5) : "k should be between 0 and 4";
            switch (k) {
                case 0: {
                    cot = 1.0;
                    sit = 0.0;
                    break;
                }
                case 1: {
                    cot = 0.0;
                    sit = 1.0;
                    break;
                }
                case 2: {
                    cot = -1.0;
                    sit = 0.0;
                    break;
                }
                case 3: {
                    cot = 0.0;
                    sit = -1.0;
                    break;
                }
                case 4: {
                    cot = 1.0;
                    sit = 0.0;
                }
            }
        } else {
            cot = Math.cos(angle);
            sit = Math.sin(angle);
        }
        return new AffineTransform2D(cot, -sit, (1.0 - cot) * cx + sit * cy, sit, cot, (1.0 - cot) * cy - sit * cx);
    }

    public static AffineTransform2D createScaling(double sx, double sy) {
        return AffineTransform2D.createScaling(new Point2D(0.0, 0.0), sx, sy);
    }

    public static AffineTransform2D createScaling(Point2D center, double sx, double sy) {
        return new AffineTransform2D(sx, 0.0, (1.0 - sx) * center.getX(), 0.0, sy, (1.0 - sy) * center.getY());
    }

    public static AffineTransform2D createShear(double shx, double shy) {
        return new AffineTransform2D(1.0, shx, 0.0, shy, 1.0, 0.0);
    }

    public static AffineTransform2D createTranslation(Vector2D vect) {
        return new AffineTransform2D(1.0, 0.0, vect.getX(), 0.0, 1.0, vect.getY());
    }

    public static AffineTransform2D createTranslation(double dx, double dy) {
        return new AffineTransform2D(1.0, 0.0, dx, 0.0, 1.0, dy);
    }

    public static boolean isIdentity(AffineTransform2D trans) {
        double[] coefs = trans.getCoefficients();
        if (Math.abs(coefs[0] - 1.0) > 1.0E-12) {
            return false;
        }
        if (Math.abs(coefs[1]) > 1.0E-12) {
            return false;
        }
        if (Math.abs(coefs[2]) > 1.0E-12) {
            return false;
        }
        if (Math.abs(coefs[3]) > 1.0E-12) {
            return false;
        }
        if (Math.abs(coefs[4] - 1.0) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(coefs[5]) > 1.0E-12);
    }

    public static boolean isDirect(AffineTransform2D trans) {
        double[][] mat = trans.getAffineMatrix();
        return mat[0][0] * mat[1][1] - mat[0][1] * mat[1][0] > 0.0;
    }

    public static boolean isIsometry(AffineTransform2D trans) {
        double[][] mat = trans.getAffineMatrix();
        double a = mat[0][0];
        double b = mat[0][1];
        double d = mat[1][0];
        double e = mat[1][1];
        if (Math.abs(a * a + d * d - 1.0) > 1.0E-12) {
            return false;
        }
        if (Math.abs(b * b + e * e - 1.0) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(a * b + d * e) > 1.0E-12);
    }

    public static boolean isMotion(AffineTransform2D trans) {
        double[][] mat = trans.getAffineMatrix();
        double det = mat[0][0] * mat[1][1] - mat[0][1] * mat[1][0];
        return Math.abs(det - 1.0) < 1.0E-12;
    }

    public static boolean isSimilarity(AffineTransform2D trans) {
        double c;
        double d;
        double k2;
        double b;
        double[][] mat = trans.getAffineMatrix();
        double a = mat[0][0];
        if (Math.abs(a * a + (b = mat[1][0]) * b - (k2 = Math.abs(a * (d = mat[1][1]) - b * (c = mat[0][1])))) > 1.0E-12) {
            return false;
        }
        if (Math.abs(c * c + d * d - k2) > 1.0E-12) {
            return false;
        }
        if (Math.abs(a * a + c * c - k2) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(b * b + d * d - k2) > 1.0E-12);
    }

    public AffineTransform2D() {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m12 = 0.0;
        this.m02 = 0.0;
    }

    public AffineTransform2D(AffineTransform2D trans) {
        double[][] mat = trans.getAffineMatrix();
        this.m00 = mat[0][0];
        this.m01 = mat[0][1];
        this.m02 = mat[0][2];
        this.m10 = mat[1][0];
        this.m11 = mat[1][1];
        this.m12 = mat[1][2];
    }

    public AffineTransform2D(double[] coefs) {
        if (coefs.length == 4) {
            this.m00 = coefs[0];
            this.m01 = coefs[1];
            this.m10 = coefs[2];
            this.m11 = coefs[3];
        } else {
            this.m00 = coefs[0];
            this.m01 = coefs[1];
            this.m02 = coefs[2];
            this.m10 = coefs[3];
            this.m11 = coefs[4];
            this.m12 = coefs[5];
        }
    }

    public AffineTransform2D(double xx, double yx, double tx, double xy, double yy, double ty) {
        this.m00 = xx;
        this.m01 = yx;
        this.m02 = tx;
        this.m10 = xy;
        this.m11 = yy;
        this.m12 = ty;
    }

    public double[] getCoefficients() {
        double[] tab = new double[]{this.m00, this.m01, this.m02, this.m10, this.m11, this.m12};
        return tab;
    }

    public double[][] getAffineMatrix() {
        double[][] tab = new double[][]{{this.m00, this.m01, this.m02}, {this.m10, this.m11, this.m12}, {0.0, 0.0, 1.0}};
        return tab;
    }

    @Deprecated
    public AffineTransform2D compose(AffineTransform2D that) {
        return this.concatenate(that);
    }

    public AffineTransform2D concatenate(AffineTransform2D that) {
        double[][] m2 = that.getAffineMatrix();
        double n00 = this.m00 * m2[0][0] + this.m01 * m2[1][0];
        double n01 = this.m00 * m2[0][1] + this.m01 * m2[1][1];
        double n02 = this.m00 * m2[0][2] + this.m01 * m2[1][2] + this.m02;
        double n10 = this.m10 * m2[0][0] + this.m11 * m2[1][0];
        double n11 = this.m10 * m2[0][1] + this.m11 * m2[1][1];
        double n12 = this.m10 * m2[0][2] + this.m11 * m2[1][2] + this.m12;
        return new AffineTransform2D(n00, n01, n02, n10, n11, n12);
    }

    public AffineTransform2D chain(AffineTransform2D that) {
        double[][] m2 = that.getAffineMatrix();
        return new AffineTransform2D(m2[0][0] * this.m00 + m2[0][1] * this.m10, m2[0][0] * this.m01 + m2[0][1] * this.m11, m2[0][0] * this.m02 + m2[0][1] * this.m12 + m2[0][2], m2[1][0] * this.m00 + m2[1][1] * this.m10, m2[1][0] * this.m01 + m2[1][1] * this.m11, m2[1][0] * this.m02 + m2[1][1] * this.m12 + m2[1][2]);
    }

    public AffineTransform2D preConcatenate(AffineTransform2D that) {
        return this.chain(that);
    }

    public boolean isSimilarity() {
        return AffineTransform2D.isSimilarity(this);
    }

    public boolean isMotion() {
        return AffineTransform2D.isMotion(this);
    }

    public boolean isIsometry() {
        return AffineTransform2D.isIsometry(this);
    }

    public boolean isDirect() {
        return AffineTransform2D.isDirect(this);
    }

    public boolean isIdentity() {
        return AffineTransform2D.isIdentity(this);
    }

    public AffineTransform2D invert() {
        double det = this.m00 * this.m11 - this.m10 * this.m01;
        if (Math.abs(det) < 1.0E-12) {
            throw new NonInvertibleTransform2DException(this);
        }
        return new AffineTransform2D(this.m11 / det, -this.m01 / det, (this.m01 * this.m12 - this.m02 * this.m11) / det, -this.m10 / det, this.m00 / det, (this.m02 * this.m10 - this.m00 * this.m12) / det);
    }

    public Point2D[] transform(Point2D[] src, Point2D[] dst) {
        if (dst == null) {
            dst = new Point2D[src.length];
        }
        if (dst[0] == null) {
            int i = 0;
            while (i < src.length) {
                dst[i] = new Point2D();
                ++i;
            }
        }
        double[] coef = this.getCoefficients();
        int i = 0;
        while (i < src.length) {
            dst[i] = new Point2D(src[i].getX() * coef[0] + src[i].getY() * coef[1] + coef[2], src[i].getX() * coef[3] + src[i].getY() * coef[4] + coef[5]);
            ++i;
        }
        return dst;
    }

    public Point2D transform(Point2D src) {
        double[] coef = this.getCoefficients();
        Point2D dst = new Point2D(src.getX() * coef[0] + src.getY() * coef[1] + coef[2], src.getX() * coef[3] + src.getY() * coef[4] + coef[5]);
        return dst;
    }

    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AffineTransform2D)) {
            return false;
        }
        double[] tab1 = this.getCoefficients();
        double[] tab2 = ((AffineTransform2D)obj).getCoefficients();
        int i = 0;
        while (i < 6) {
            if (Math.abs(tab1[i] - tab2[i]) > eps) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return new String("AffineTransform2D(" + this.m00 + "," + this.m01 + "," + this.m02 + "," + this.m10 + "," + this.m11 + "," + this.m12 + ",");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AffineTransform2D)) {
            return false;
        }
        double[] tab1 = this.getCoefficients();
        double[] tab2 = ((AffineTransform2D)obj).getCoefficients();
        int i = 0;
        while (i < 6) {
            if (Double.doubleToLongBits(tab1[i]) != Double.doubleToLongBits(tab2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public AffineTransform2D clone() {
        return new AffineTransform2D(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12);
    }
}

